//Solve the s-wave Schrodinger equation for the ground state and the first excited
//state of the hydrogen atom.

close;
clear;
clc;

// declaring constant values
hbarc=1973;// Plancks constant = h , hbar*c=(h/2*pi)^c. 
mcsq=0.511*10^(6);    // (mass of electron)*c ^2 in units of (eV);
e = 3.795; // (eVÅ)^1/2
//a = input("Input the vaue of a in units of angstrom: ") ; 
a=3 ; // in units of Angstrom
// we can check it for 3, 5, 7 angstrom etc..

r_min=0 // in units of angstrom
r_max=5 // in units of angstrom
N =  input("Input the number of intervals (should be around 500 to 1000 for good computation): ")
s = (r_max-r_min)/N; //step size 
factor1=-(hbarc^2)/(2*mcsq*s^2);  
// this factor is (hbar^2*c^2/2m*c^2) divided by s^2 //k=(hbar_c*hbar_c)/(2*m)

// Kinetic energy matrix (Using central difference formula)
T=zeros(N-1,N-1)
for i=1:N-1
    T(i,i)=-2
    if i<N-1 then
        T(i,i+1)=1
        T(i+1,i)=1
     end
end
// Kinetic Energy Matrix final (scaling factor included)
T_matrix = factor1*T;    

//Potential energy matrix
V_matrix=zeros(N-1,N-1)
for i=1:N-1
    r(i)=r_min+i*s
    V_vector(i,1) = -((e*e)/r(i))*exp(-r(i)/a);
    V_matrix(i,i)=-((e*e)/r(i))*exp(-r(i)/a);
end

// This is to plot the potential V(r)as a function of r
figure;
plot(r,V_vector,'-.','linewidth',3)
xlabel('r (in Angstrom units)','fontsize',2)
ylabel('V(r)','fontsize',2)
legend (['Screened coloumb potential'])

// Hamiltonian matrix
H_matrix=T_matrix+V_matrix

// energy eigenvalue and eigenstates
[u,eigen]=spec(H_matrix);

// displaying of the groundstate energies
disp("Ground state energy in the presence of screened coloumb potential is : ")
disp(eigen(1,1))

//Radial wavefuction
figure();
Psi=u(:,1)./r;
plot(r,Psi, 'm', 'linewidth',3)
title('Eign function plot in presence of screened coloumb potential','fontsize',2)
xlabel('r (in Angstrom units)','fontsize',2)
ylabel('Eigen Function','fontsize',2)
legend (['Ground state wavefunction'])




